 aR  w - mP9      h	 o     nSystem-wide    NAME Roms

; This is Rom.Asm.  This file contains the
; routines that deal with the low level roms

DGROUP GROUP DATA
CGROUP GROUP CODE


EXTRN  RomSubsystem: NEAR, CpSetActiveEmsSlot: NEAR
EXTRN  myRomID: ABS


PUBLIC InitRoms, CpGetMyRomSlot, CpGetSlotAddress
PUBLIC CpSetActiveSlot, IntCpSetActiveRomSlot

PUBLIC curSlot, numRomSlots, romsExecute


; constants

selectRomSystem   EQU 0E4H
romSystemInt      EQU 015H

getRomSysInfo     EQU 0
initRomSystem     EQU 1
getRomImageInfo   EQU 2
bankInRomImage    EQU 3
disableRoms       EQU 4

romErrNoRomsExist EQU 3
romErrNoSubsystem EQU 86H

ibmPc             EQU 2
ibmAt             EQU 3
gridOsRom         EQU 47H

invalidSlot       EQU 0FEH

TRUE              EQU 1
FALSE             EQU 0
NULLBYTE          EQU 0FFH


slotOffsetFromSP  EQU 2	; where value slot will be if only argument
$EJECT

; data

DATA SEGMENT PUBLIC 'DATA'

EXTRN  emsValid: BYTE, gridMachine: BYTE, systemType: BYTE

	romsExist      DB ?
	romSysPresent  DB ?
	romSysDataArea DW ?

	curSlot        DB ?
	numRomSlots    DB ?	; A misnomer; really num of log rom images
	romsExecute    DB ?

DATA ENDS
$EJECT

CODE SEGMENT BYTE PUBLIC 'CODE'
    ASSUME CS:CGROUP, DS:DGROUP

; InitRoms: PROCEDURE CLEAN;
;
; This will initialize the rom subsystem which figures out what roms exist

InitRoms PROC FAR
	MOV	curSlot, invalidSlot	; Initialize curSlot to "no slot"

	MOV	AL, FALSE
	MOV	romsExist, AL	; romsExist = FALSE
	MOV	romsExecute, AL	; romsExecute = FALSE
	MOV	romSysPresent, AL	; romSysPresent = FALSE
	MOV	numRomSlots, AL	; numRomSlots = 0

	TEST	gridMachine, TRUE	; if not a GRiD manufactured machine
	JZ	InitRomsRet	; then there will be no ROMs

	MOV	AH, selectRomSystem	; romSubSystem select code for Int 15H
;	MOV	AL, getRomSysInfo	; getRomSysInfo = 0 = AL = FALSE
	INT	romSystemInt	; See if rom bios supports romSubSystem
	JC	UseRomSubsystem	; Nope, use internal system

	MOV	romSysPresent, TRUE	; rom bios supported romSubSystem exists
	JMP	SHORT InitRomsCont1

UseRomSubsystem:
	CMP	AH, romErrNoSubsystem
	JNE	InitRomsRet
	CALL	RomSubsystem	; Send get info request to local subsystem

InitRomsCont1:
	MOV	AH, 48H	; Allocate memory
	INT	21H
	JC	InitRomsRet

	MOV	romSysDataArea, AX
	MOV	AL, initRomSystem
	CALL	RomSubsystemEntry
	JNC	InitRomsCont2

	MOV	ES, romSysDataArea	; Free the rom data area memory
	MOV	AH, 49H	; if there are no roms present
	INT	21H
	JMP	SHORT InitRomsRet

InitRomsCont2:
	MOV	numRomSlots, AL	; Returned by initRomSystem call

	CMP	systemType, IBMPc	; If running on AT architecture
	JNE	InitRomsExit	; then ROMs don't exist in 512k-640k range

	XOR	DX, DX	; Index for rom slots
	MOV	SI, DX	; Use SI to count GRiD Roms

InitRomsLoop:
	MOV	AL, getRomImageInfo
	CALL	RomSubsystemEntry
	JC	InitRomsNext

	CMP	DH, gridOsRom
	JNE	InitRomsNext

	INC	SI	; Another GRiD Rom
	MOV	AX, myRomID	; If myRomID
	OR	AX, AX	; is zero (non-ROM InteGRiD)
	JZ	InitRomsNext	; then check next ROM

	CMP	AX, BX	; else if myRomID is here
	JE	InitRomsSomeExecute	; then have ROMs execute

InitRomsNext:
	INC	DX
	CMP	DL, numRomSlots
	JNE	InitRomsLoop

	OR	SI, SI	; If there aren't any GRiD format ROMs
	JZ	InitRomsExit	; then don't use 512-640 for ROMs

	TEST	emsValid, TRUE	; If running on PC architecture with EMS
	JNZ	InitRomsExit	; then don't execute, but drag into EMS

InitRomsSomeExecute:
	MOV	romsExecute, TRUE

InitRomsExit:
	MOV	romsExist, TRUE

InitRomsRet:
	RET
InitRoms ENDP
$EJECT

; CpGetMyRomSlot: PROCEDURE (romID) BYTE CLEAN
;     DCL romID WORD
;
; This will return the slot # of the rom which
; has the given ID.  If the romID is not found, then
; nullByte will be returned

romID EQU WORD PTR [BP+8]

CpGetMyRomSlot PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	TEST	romsExist, TRUE
	JZ	CpGetMySlotNotFound

	MOV	SI, romID	; save romID in SI
	XOR	DI, DI	; start with slot 0

CpGetMySlotLoop:
	MOV	DX, DI
	MOV	AL, getRomImageInfo	; Returns romID in BX
	CALL	RomSubsystemEntry
	JC	CpGetMySlotNext

	MOV	AX, DI
	CMP	BX, SI
	JE	CpGetMySlotRet

CpGetMySlotNext:
	INC	DI
	XCHG	AX, DI
	CMP	AL, numRomSlots
	XCHG	AX, DI
	JB	CpGetMySlotLoop

CpGetMySlotNotFound:
	MOV	AL, NULLBYTE

CpGetMySlotRet:
	POP	BP
	POP	DS
	RET	2
CpGetMyRomSlot ENDP

PURGE romID
$EJECT

; CpSetActiveSlot: PROCEDURE (slot) BYTE CLEAN;
;     DCL slot BYTE;
;
; This level of CpSetActiveSlot will either return the current
; slot (when slot = 0FFH); set/disable a ROM slot
; (when slot = 0..numRomSlots - 1); set an EMS slot and disable
; roms (when slot = emsFirst..emsLast); or turn off roms when
; slot is unused (when slot = 0FEH)

newSlot EQU BYTE PTR [BP+8]

CpSetActiveSlot PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	MOV	AL, curSlot
	MOV	BL, newSlot
	CMP	BL, NULLBYTE
	JE	CpSetActiveSlotRet

	PUSH	BX	; Get ready to pass new slot to ems/rom
	AND	BL, 7FH
	CMP	BL, numRomSlots
	JAE	CpSetEmsSlots

CpSetRomSlots:
	CALL	CpSetActiveRomSlot
	JMP	CpSetActiveSlotRet

CpSetEmsSlots:
	CALL	CpSetActiveEmsSlot

CpSetActiveSlotRet:
	POP	BP
	POP	DS
	RET	2
CpSetActiveSlot ENDP

PURGE newSlot
$EJECT

; CpSetActiveRomSlot: PROCEDURE (slot) BYTE CLEAN;
;     DCL slot BYTE;
;
; This will make the rom specified by slot be the "active" rom.
; A verification is made to see that the slot specified exists.
; It is assumed that the values passed to this routine have been
; verified to be in the rom range (0 -> numRomSlots - 1).
; It is also assumed that the NULLBYTE case has been handled.

CpSetActiveRomSlot PROC NEAR
	MOV	AL, curSlot	; save current slot
	TEST	romsExist, TRUE
	JZ	CpSetActiveRomRet

	MOV	SI, SP
	ADD	SI, slotOffsetFromSP

	MOV	DL, SS:[SI]	; DL = slot
	AND	DL, 7FH	; Mask off disable bit while checking
	MOV	AL, getRomImageInfo
	CALL	RomSubsystemEntry
	MOV	AL, NULLBYTE
	JC	CpSetActiveRomRet

	MOV	AL, curSlot	; save current slot
	PUSH	AX
	MOV	AL, SS:[SI]	; AL = slot
	CALL	IntCpSetActiveRomSlot
	POP	AX

CpSetActiveRomRet:
    RET 2
CpSetActiveRomSlot ENDP
$EJECT

; IntCpSetActiveRomSlot
;	This is the level of CpSet*Slot called from SwapTasksRoutine.
;   It has to handle the situation of storing an invalid slot and
;   storing an EMS slot, since the SwapTasksRoutine is saving and
;   restoring the EMS context.  It will also disable ROMs if they
;   exist when banking in EMS or an invalid (unused) slot.

;	The first test below should cover all cases for disabling ROMs
;	including invalidSlot (i.e. 0FEH), EMS slots (> numRomSlots),
;   ROMs that are temporarily off (rom slots ORed w/80H)

; Entry
;	DS => DGROUP of InteGRiD
;   AL =  rom slot to be set (already verified as being valid)

IntCpSetActiveRomSlot PROC NEAR
	MOV	CL, curSlot	; Save curSlot for optimization below

	MOV	curSlot, AL	; Store the rom slot as the current slot
	CMP	AL, numRomSlots	; Only rom slots 0 to numRomSlots-1
	JB	BankInARomSlot	; require banking in a rom slot

DisableRomSlots:
	CMP	CL, numRomSlots	; If old slot was not a ROM slot
	JAE	IntCpSetActiveRomRet	; then ROMs must already be off

	TEST	romsExist, TRUE	; If ROMs aren't even installed
	JZ	IntCpSetActiveRomRet	; also no need to turn "them" off

	MOV	AL, disableRoms	; Else disable roms
	JMP	SHORT CallSubsystemHere

BankInARomSlot:
	MOV	DL, AL	; Slot value is in DL
	MOV	AL, bankInRomImage	; Bank in a rom image

CallSubsystemHere:
	CALL	RomSubsystemEntry	; Call Rom subsystem

IntCpSetActiveRomRet:
	RET		; Done
IntCpSetActiveRomSlot ENDP
$EJECT

; CpGetSlotAddress: PROCEDURE (slot) PTR CLEAN
;     DCL slot BYTE;
;
; This will return the actual address of a given slot
; If slot is nullByte, then curSlot will be used

theSlot EQU BYTE PTR [BP+8]

CpGetSlotAddress PROC FAR
	PUSH	DS
	PUSH	BP
	MOV	BP, SP
	MOV	AX, DGROUP
	MOV	DS, AX

	TEST	romsExist, TRUE
	JZ	CpGetSlotAddressRet

	MOV	DL, theSlot
	MOV	AL, getRomImageInfo	; returns ES = rom base address
	CALL	RomSubsystemEntry
	XOR	BX, BX                   ; BX = 0

CpGetSlotAddressRet:
	POP	BP
	POP	DS
	RET	2
CpGetSlotAddress ENDP

PURGE theSlot
$EJECT

; Entry
;   DS => DGROUP of InteGRiD
;   AL =  function number of rom subsystem call
;   other registers set as required by each rom subsystem call

; Exit
;	AH = error return (& carry set if non-zero)
;   other returns depend upon call

RomSubsystemEntry PROC NEAR
	PUSH	DS
	TEST	romSysPresent, TRUE
	MOV	AH, selectRomSystem	; romSubSystem select code for Int 15H
	MOV	DS, romSysDataArea
	JZ	IntSubsystemEntry

ExtSubsystemEntry:
	INT	romSystemInt
	JMP	SHORT RomSubsystemEntryRet

IntSubsystemEntry:
	CALL	RomSubsystem

RomSubsystemEntryRet:
	POP	DS
	RET
RomSubsystemEntry ENDP


CODE ENDS

    END
